<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Requests\Notification\NotificationContent;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | notification requests
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_NOTIFICATION_LOAD_LATEST:
        NotificationContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_NOTIFICATION_LOAD_BOTTOM:
        NotificationContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // meta

    case RequestConstants::REQ_TYPE_NOTIFICATION_COUNT: NotificationContent::count();

    break;
}
